% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_meth_site_transcript_cors.R
\name{calculateMethSiteTranscriptCors}
\alias{calculateMethSiteTranscriptCors}
\title{Calculate correlation between expression of transcripts and methylation of sites surrounding their TSS}
\usage{
calculateMethSiteTranscriptCors(
  meth_rse,
  assay_number = 1,
  transcript_expression_table,
  samples_subset = NULL,
  tss_gr,
  tss_associated_gr,
  cor_method = "pearson",
  min_number_complete_pairs = 30,
  add_distance_to_region = TRUE,
  max_sites_per_chunk = NULL,
  BPPARAM = BiocParallel::SerialParam(),
  results_dir = NULL
)
}
\arguments{
\item{meth_rse}{A RangedSummarizedExperiment for methylation sites.}

\item{assay_number}{The assay from meth_rse to extract values from. Default is the first assay.}

\item{transcript_expression_table}{A matrix or data.frame with the expression values for transcripts, where row names are transcript names and columns sample names.
There should be a row corresponding to each transcript associated with each range in tss_gr.
Names of samples must match those in meth_rse unless samples_subset provided.}

\item{samples_subset}{Sample names used to subset meth_rse and transcript_expression_table. Provided samples must be found in both meth_rse and transcript_expression_table.
Default is to use all samples in meth_rse and transcript_expression_table.}

\item{tss_gr}{A GRanges object with the locations of transcription start sites.
Names of regions cannot contain any duplicates and should and match those of tss_associated_gr and be present in transcript_expression table.}

\item{tss_associated_gr}{A GRanges object with the locations of regions associated with each transcription start site.
Names of regions cannot contain any duplicates and should and match those of tss_gr and be present in transcript_expression table.}

\item{cor_method}{A character string indicating which correlation coefficient is to be computed.
One of either "pearson" or "spearman" or their abbreviations.}

\item{min_number_complete_pairs}{The minimum number of complete pairs required to return a p-value for a correlation.
Correlations with less than this number are given a p-value of NaN. Default value is 30.}

\item{add_distance_to_region}{TRUE or FALSE indicating whether to add the distance of methylation sites to the TSS. Default value is TRUE.
Setting to FALSE will roughly half the total running time.}

\item{max_sites_per_chunk}{The approximate maximum number of methylation sites to try to load into memory at once.
The actual number loaded may vary depending on the number of methylation sites overlapping each region,
but so long as the size of any individual regions is not enormous (>= several MB), it should vary only very slightly.
Some experimentation may be needed to choose an optimal value as low values will result in increased running time,
while high values will result in a large memory footprint without much improvement in running time.
Default is floor(62500000/ncol(meth_rse)), resulting in each chunk requiring approximately 500 MB of RAM.}

\item{BPPARAM}{A BiocParallelParam object for parallel processing. Defaults to \code{BiocParallel::SerialParam()}.}

\item{results_dir}{An optional path to a directory to save results as RDS files. There will be one RDS file for each transcript.
If not provided, returns the results as a list.}
}
\value{
If results_dir is NULL, a list of data.frames with the correlation of methylation sites surrounding a specified
genomic region with a given feature, p-values and adjusted q-values for the correlations.
Distance of the methylation sites upstream or downstream to the center of the region is also provided.
If results_dir is provided, instead returns a list with the paths to the RDS files with the results.
}
\description{
Calculate correlation between expression of transcripts and methylation of sites surrounding their TSS
}
\examples{

# Load TUBB6 TSS GRanges, RangedSummarizedExperiment with methylation values for CpGs around TUBB6 TSS and TUBB6 transcript counts
data(tubb6_tss, package = "methodical")
data(tubb6_meth_rse, package = "methodical")
tubb6_meth_rse <- eval(tubb6_meth_rse)
data(tubb6_transcript_counts, package = "methodical")

# Calculate correlation values between methylation values and transcript values for TUBB6
tubb6_cpg_meth_transcript_cors <- methodical::calculateMethSiteTranscriptCors(meth_rse = tubb6_meth_rse,
  transcript_expression_table = tubb6_transcript_counts, tss_gr = tubb6_tss, 
  tss_associated_gr = methodical::expand_granges(tubb6_tss, upstream = 5000, downstream = 5000))
head(tubb6_cpg_meth_transcript_cors$ENST00000591909)

}
