% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callMethylation.R
\name{binomialTestMethylation}
\alias{binomialTestMethylation}
\title{Call methylation status}
\usage{
binomialTestMethylation(data, conversion.rate, min.coverage = 3,
  p.threshold = 0.05)
}
\arguments{
\item{data}{A \code{\link{methimputeData}} object.}

\item{conversion.rate}{A conversion rate between 0 and 1.}

\item{min.coverage}{Minimum coverage to consider for the binomial test.}

\item{p.threshold}{Significance threshold between 0 and 1.}
}
\value{
A vector with methylation statuses.
}
\description{
Call methylation status of cytosines (or bins) with a binomial test.
}
\details{
The function uses a binomial test with the specified \code{conversion.rate}. P-values are then multiple testing corrected with the Benjamini & Yekutieli procedure. Methylated positions are selected with the \code{p.threshold}.
}
\examples{
## Get some toy data
file <- system.file("data","arabidopsis_toydata.RData", package="methimpute")
data <- get(load(file))
data$binomial <- binomialTestMethylation(data, conversion.rate=0.998)

}
