% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{runDreme}
\alias{runDreme}
\title{Denovo motif discovery of target regions using DREME}
\usage{
runDreme(input, control, outdir = "auto", meme_path = NULL, silent = TRUE, ...)
}
\arguments{
\item{input}{regions to scan for motifs. Can be any of:
\itemize{
\item path to fasta file
\item DNAStringSet object (can be generated from GRanges using \code{get_sequence()})
\item List of DNAStringSet objects (generated from \code{get_sequence()})
\item \emph{NOTE:} if using StringSet inputs, each entry must be named (set with \code{names()}).
\item \emph{NOTE:} If you want to retain the raw dreme output files, you must use a
path to fasta file as input, or specify an "outdir"
}}

\item{control}{regions to use as background for motif search. Can be any of:
\itemize{
\item path to fasta file
\item DNAStringSet object (can be generated from GRanges using get_sequence)
\item A Biostrings::BStringSetList (generated using \code{get_sequence}), in which
case all sequences in the list will be combined as the control set.
\item if \code{input} is a list of DNAStringSet objects, a character vector of names
in \code{input} will use those sequences as background. runDreme will not scan
those regions as input.
\item "shuffle" to use dreme's built-in dinucleotide shuffle feature (NOTE: if
\code{input} is a list object with an entry named "shuffle", the list entry will
be used instead).
Optionally can also pass \verb{seed = <any number>} to \code{...} to use as the random
seed during shuffling. If no seed is passed, dreme will use 1 as the random
seed, so results will be reproducible if rerunning. \strong{NOTE:} beware
system-specific differences. As of v5, dreme will compile using the default
python installation on a system (either python2.7 or python3). The random
number generator changed between python2.7 and python3, so results will not
be reproducible between systems using python2.7 vs 3.
}}

\item{outdir}{path to output directory of dreme files, or "auto" to autogenerate path. Default: location of
input fasta in dir named "\<input\>\emph{vs}\<control\>". If input is
DNAstringset, will be temporary path. This means that if you want to save
the raw output files, you must use fasta files as input or use an
informative (and unique) outdir name. memes will \strong{not check} if it
overwrites files in a directory. Directories will be recursively created if needed.}

\item{meme_path}{optional, path to "meme/bin/" on your local machine.
runDreme will search 3 places in order for meme if this flag is unset:
\enumerate{
\item the option "meme_bin" (set with options(meme_bin = "path/to/meme/bin"))
\item the environment variable "MEME_PATH" (set in .Renviron)
\item "~/meme/bin/" as the default location
}
\itemize{
\item If the user sets meme_path in the function call, this value will always be used
}}

\item{silent}{whether to suppress printing dreme stdout as a message when
finishing with no errors. Can be useful for troubleshooting in situations
where no motifs are discovered, but command completes successfully.
(default: TRUE)}

\item{...}{dreme flags can be passed as R function arguments to use
non-default behavior. For a full list of valid arguments, run your local
install of dreme -h, or visit the dreme documentation
\href{http://meme-suite.org/doc/dreme.html}{website}. See list below for aliases
of common flags. To set flags with no values (ex. \code{-dna}), pass the
argument as a boolean value (ex. \code{dna = TRUE}).}
}
\value{
\code{universalmotif_df} with statistics for each discovered motif. The \code{motif}
column contains a universalmotif object representation in PCM format of
each DREME motif. If no motifs are discovered, returns NULL. The column
values are as follows:
\itemize{
\item rank = ranked order of discovered motif
\item name = primary name of motif
\item altname = alternative name of motif
\item seq = consensus sequence of the motif
\item length = length of discovered motif
\item nsites = number of times the motif is found in input sequences
\item positive_hits = number of sequences in input containing at least 1 of the motif
\item negative_hits = number of sequences in control containing at least 1 of the motif
\item pval = p-value
\item eval = E-value
\item unerased_eval = Unerased E-Value
\item positive_total = number of sequences in input
\item negative_total = number of sequences in control
\item pos_frac = fraction of positive sequences with a hit
\item neg_frac = fraction of negative sequences with a hit
\item motif = a universalmotif object of the discovered motif
}
}
\description{
DREME discovers short, ungapped, \emph{de-novo} motifs that are relatively
enriched relative to a control set of sequences. DREME can be run to discover
motifs relative to a shuffled set of input sequences, or against a separately
provided set of "control" sequences.
}
\details{
Properly setting the \code{control} parameter is key to discovering biologically
relevant motifs. Often, using \code{control = "shuffle"} will produce a suboptimal
set of motifs; however, some discriminative analysis designs don't have
proper "control" regions other than to shuffle.

As of MEME version 5.2.0, DREME is deprecated. Consider \code{\link[=runStreme]{runStreme()}} instead.

In addition to allowing any valid flag of dreme to be passed to \code{...}, we
provide a few user-friendly aliases for common flags which are more readable (see list below).
For example, e = 1 will use a max evalue cutoff of 1. This is equivalent to
setting evalue = 1. For additional details about each DREME flag, see the
\href{http://meme-suite.org/doc/dreme.html}{DREME Manual Webpage}.

List of values which can be passed to \code{...}:
\strong{NOTE:} values must be referred to using their name in the "memes alias"
column, not the "DREME Flag" column.\tabular{cclc}{
   memes alias \tab DREME Flag \tab description \tab default \cr
   nmotifs \tab m \tab max number of motifs to discover \tab NULL \cr
   sec \tab t \tab max number of seconds to run \tab NULL \cr
   evalue \tab e \tab max E-value cutoff \tab 0.05 \cr
   seed \tab s \tab random seed if using "shuffle" as control \tab 1 \cr
   ngen \tab g \tab nuber of REs to generalize \tab 100 \cr
   mink \tab mink \tab minimum motif width to search \tab 3 \cr
   maxk \tab maxk \tab maximum motif width to search \tab 7 \cr
   k \tab k \tab set mink and maxk to this value \tab NULL \cr
   norc \tab norc \tab search only the input strand for sequences \tab FALSE \cr
   dna \tab dna \tab use DNA alphabet \tab TRUE \cr
   rna \tab rna \tab use RNA alphabet \tab FALSE \cr
   protein \tab protein \tab use protein alphabet (NOT RECCOMENDED) \tab FALSE \cr
}
}
\section{Citation}{
If you use \code{runDreme()} in your analysis, please cite:

Timothy L. Bailey, "DREME: Motif discovery in transcription factor ChIP-seq
data", Bioinformatics, 27(12):1653-1659, 2011.
\href{https://academic.oup.com/bioinformatics/article/27/12/1653/257754}{full text}
\subsection{Licensing}{

The MEME Suite is free for non-profit use, but for-profit users should purchase a
license. See the \href{http://meme-suite.org/doc/copyright.html}{MEME Suite Copyright Page} for details.
}
}

\examples{
if (meme_is_installed()) {
# Create random named sequences as input for example
seqs <- universalmotif::create_sequences(rng.seed = 123)
names(seqs) <- seq_along(seqs)

# Runs dreme with default settings, shuffles input as background
runDreme(seqs, "shuffle")

# Runs searching for max 2 motifs, e-value cutoff = 0.1, explicitly using the DNA alphabet
runDreme(seqs, "shuffle", nmotifs = 2, e = 0.1, dna = TRUE)
}
}
