% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logisitic_Regression.R
\name{logRegSnpsTaxa}
\alias{logRegSnpsTaxa}
\title{\code{logRegSnpsTaxa} Performs logistic regression analysis between taxa and SNPs and returns concordance statistics}
\usage{
logRegSnpsTaxa(microbeAbund, SnpFile, cutoff = NULL, selectmicrobe = NULL)
}
\arguments{
\item{microbeAbund}{the taxa abundance dataframe (rownames sample names and colnames taxa Genus/species/family)}

\item{SnpFile}{the snp dataframe (values 0,1,2 indicating zygosity), rownames sample names and colnames snp names.}

\item{cutoff}{default is NULL, hence anything above cutoff is considered positive, the cutoff at which the
specific or all taxa are considered positive for the pathogen (1 indicates positive and 0 negative).}

\item{selectmicrobe}{default is and all taxa are considered at the same time, if the user is interested in a
specific pathogen use name of the pathogen for example "Haemophilus".}
}
\value{
A data frame which is a result of Logistic regression  products of individual snp, taxa relationships,
with P values and P value corrected values (FDR, Bonferroni).
}
\description{
This function creates a dataframe output from the results of either a unique taxa and all snps or all taxa and
all snps in the dataset. The result is a dataframe with P values and FDRs of all regressions.
}
\examples{
data(microbeAbund)
data(SnpFile)
x <- logRegSnpsTaxa(microbeAbund, SnpFile, selectmicrobe = c("Haemophilus"))

}
\keyword{logistic_regression}
\keyword{logit}
\keyword{snp}
\keyword{taxa}
