% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/get_degs-methods.R
\name{get_degs}
\alias{get_degs}
\alias{get_degs,DGEList,character,character-method}
\alias{get_degs,matrix,vector,character-method}
\alias{get_degs,Matrix,vector,character-method}
\alias{get_degs,ExpressionSet,character,character-method}
\alias{get_degs,SummarizedExperiment,character,character-method}
\alias{get_degs,Seurat,character,character-method}
\title{Get differentially expressed genes by comparing specified groups}
\usage{
get_degs(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  feature_selection = c("auto", "rankproduct", "none"),
  slot = "counts",
  batch = NULL,
  ...
)

\S4method{get_degs}{DGEList,character,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  feature_selection = c("auto", "rankproduct", "none"),
  slot = "counts",
  batch = NULL,
  ...
)

\S4method{get_degs}{matrix,vector,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  feature_selection = c("auto", "rankproduct", "none"),
  slot = "counts",
  batch = NULL,
  ...
)

\S4method{get_degs}{Matrix,vector,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  feature_selection = c("auto", "rankproduct", "none"),
  slot = "counts",
  batch = NULL,
  ...
)

\S4method{get_degs}{ExpressionSet,character,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  feature_selection = c("auto", "rankproduct", "none"),
  slot = "counts",
  batch = NULL,
  ...
)

\S4method{get_degs}{SummarizedExperiment,character,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  feature_selection = c("auto", "rankproduct", "none"),
  slot = "counts",
  batch = NULL,
  ...
)

\S4method{get_degs}{Seurat,character,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  feature_selection = c("auto", "rankproduct", "none"),
  slot = "counts",
  batch = NULL,
  ...
)
}
\arguments{
\item{data}{expression object}

\item{group_col}{vector or character, specify the group factor or column name of
coldata for DE comparisons}

\item{target_group}{pattern, specify the group of interest, e.g. NK}

\item{normalize}{logical, if the expr in data is raw counts needs to be normalized}

\item{feature_selection}{one of "auto" (default), "rankproduct" or "none",
choose if to use rank product or not to select DEGs
from multiple comparisons of DE analysis, 'auto'
uses 'rankproduct' but change to 'none' if final
genes < 5 for both UP and DOWN}

\item{slot}{character, specify which slot to use only for DGEList, sce or
seurat object, optional, default 'counts'}

\item{batch}{vector of column name(s) or dataframe, specify the batch effect
factor(s), default NULL}

\item{...}{params for \code{\link[=process_data]{process_data()}} and \code{\link[=select_sig]{select_sig()}}}
}
\value{
A list of 'UP', 'DOWN' gene set of all differentially expressed
genes, and a DGEList 'proc_data' containing data after process
(filtration, normalization and voom fit). Both 'UP' and 'DOWN' are
ordered by rank product or 'Rank' variable if keep.top is NULL
}
\description{
This function uses edgeR and limma to get 'UP' and 'DOWN' DEG
lists, for multiple comparisons, DEGs can be obtained from intersection of
all DEGs or by using product of p value ranks for multiple
comparisons. Filter out low expressed genes and extract DE genes by using
limma::voom and limma::treat, and also create an object \code{proc_data} to
store processed data.
}
\examples{
data("im_data_6")
DEGs <- get_degs(im_data_6,
  group_col = "celltype:ch1",
  target_group = "NK", gene_id = "ENSEMBL"
)

}
