% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_sig_by_step.R
\name{plot_diagnostics}
\alias{plot_diagnostics}
\title{plot diagnostics before and after \code{\link[=process_data]{process_data()}}}
\usage{
plot_diagnostics(expr1, expr2, group_col, abl = 2)
}
\arguments{
\item{expr1}{expression matrix 1 for original data}

\item{expr2}{expression matrix 2 for processed data}

\item{group_col}{vector of group of samples}

\item{abl}{num, cutoff line}
}
\value{
multiple plots
}
\description{
plot diagnostics before and after \code{\link[=process_data]{process_data()}}
}
\examples{
data("im_data_6")
dge <- edgeR::DGEList(
  counts = Biobase::exprs(im_data_6),
  samples = Biobase::pData(im_data_6)
)
dge$logCPM <- edgeR::cpm(dge, log = TRUE)
proc_data <- process_data(dge,
  group_col = "celltype.ch1",
  target_group = "NK"
)
plot_diagnostics(proc_data$logCPM, proc_data$vfit$E,
  group_col = proc_data$samples$group
)
}
