% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maser.R
\docType{methods}
\name{summary,Maser-method}
\alias{summary,Maser-method}
\title{Retrieve rMATS stats of differential splicing from a maser object.}
\usage{
\S4method{summary}{Maser}(object, type = c("A3SS", "A5SS", "SE", "RI", "MXE"))
}
\arguments{
\item{object}{a maser object.}

\item{type}{a character indicating the splice type. Possible values 
are  \code{c("A3SS", "A5SS", "SE", "RI", "MXE")}.}
}
\value{
a data.frame.
}
\description{
Retrieve rMATS stats of differential splicing from a maser object.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
head(summary(hypoxia, "SE"))
}
