% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneEvents.R
\name{plotUniprotKBFeatures}
\alias{plotUniprotKBFeatures}
\title{Mapping and visualization of UniprotKB protein features affected by splicing.}
\usage{
plotUniprotKBFeatures(events, type = c("A3SS", "A5SS", "SE", "RI", "MXE"),
  event_id, gtf, features, zoom = FALSE, show_transcripts = FALSE,
  show_PSI = TRUE, ncores = 1)
}
\arguments{
\item{events}{a maser object.}

\item{type}{character indicating splice type. Possible values are
\code{c("A3SS", "A5SS", "SE", "RI", "MXE")}.}

\item{event_id}{numeric, event identifier.}

\item{gtf}{a \code{GRanges}, Ensembl or Gencode GTF using the hg38 build of
the human genome.}

\item{features}{a character vector indicating valid UniprotKB features.}

\item{zoom}{logical, zoom to the genomic coordinates of the splice event.}

\item{show_transcripts}{logical, display transcripts track.}

\item{show_PSI}{logical, display the PSI  track.}

\item{ncores}{number of cores for multithreading (available only in OSX and Linux 
machines). If Windows, \code{ncores} will be set to 1 automatically.}
}
\value{
a Gviz object.
}
\description{
Mapping and visualization of UniprotKB protein features affected by splicing.
}
\details{
This is a wrapper function for performing both mapping and 
visualization of protein features affected by the splice event. This function
 calls \code{\link{mapProteinFeaturesToEvents}} for mapping of protein
 features to splicing events. 
 
The \code{\link[Gviz:plotTracks]{GViz}} package is used for creating
 annotation tracks for genomic visualization. 

Multiple protein annotation tracks can be created using the \code{features}
argument.
}
\examples{
## Create the maser object
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
hypoxia_filt <- filterByCoverage(hypoxia, avg_reads = 5)

## Ensembl GTF annotation for SRSF6
gtf_path <- system.file("extdata", file.path("GTF", 
   "SRSF6_Ensembl85.gtf"), package = "maser")
ens_gtf <- rtracklayer::import.gff(gtf_path)

## Retrieve gene specific splicing events
srsf6_events <- geneEvents(hypoxia_filt, geneS = "SRSF6")

## Map splicing events to transcripts
srsf6_mapped <- mapTranscriptsToEvents(srsf6_events, ens_gtf)

## Plot splice event, transcripts and protein features
plotUniprotKBFeatures(srsf6_mapped, "SE", event_id = 33209, gtf = ens_gtf, 
  features = c("domain"), show_transcripts = TRUE)

}
\seealso{
\code{\link{mapProteinFeaturesToEvents}}
}
