% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maser.R
\docType{methods}
\name{granges,Maser-method}
\alias{granges,Maser-method}
\title{Retrieve genomic ranges of splicing events from a maser object.}
\usage{
\S4method{granges}{Maser}(x, type = c("A3SS", "A5SS", "SE", "RI", "MXE"), ...)
}
\arguments{
\item{x}{a maser object.}

\item{type}{a character indicating the splice type. Possible values 
are  \code{c("A3SS", "A5SS", "SE", "RI", "MXE")}.}

\item{...}{additional arguments.}
}
\value{
a GRangesList.
}
\description{
Retrieve genomic ranges of splicing events from a maser object.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
head(granges(hypoxia, type = "SE"))
}
