% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maser.R
\name{PSI}
\alias{PSI}
\title{Retrieve PSI (percent spliced in) values from a maser object.}
\usage{
PSI(events, type)
}
\arguments{
\item{events}{a maser object.}

\item{type}{a character indicating the splice type. Possible values 
are  \code{c("A3SS", "A5SS", "SE", "RI", "MXE")}.}
}
\value{
a matrix.
}
\description{
Retrieve PSI (percent spliced in) values from a maser object.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
head(PSI(hypoxia, "SE"))
}
