% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{get_GS_network}
\alias{get_GS_network}
\title{Get genomic sequence network}
\usage{
get_GS_network(gwas)
}
\arguments{
\item{gwas}{A SnpMatrix object with the GWAS information.}
}
\value{
An igraph network of the GS network of the SNPs.
}
\description{
Creates a network of SNPs where each SNP is connected to its 
adjacent SNPs in the genome sequence. Corresponds to the genomic sequence 
(GS) network described by Azencott et al.
}
\examples{
get_GS_network(minigwas)
}
\references{
Azencott, C. A., Grimm, D., Sugiyama, M., Kawahara, Y., &
Borgwardt, K. M. (2013). Efficient network-guided multi-locus association
mapping with graph cuts. Bioinformatics, 29(13), 171-179.
\url{https://doi.org/10.1093/bioinformatics/btt238}
}
