% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{MarrPlotFeatures}
\alias{MarrPlotFeatures}
\title{Plot percent reproducible sample pairs per feature
for pairwise replicates from \code{Marr} function.}
\usage{
MarrPlotFeatures(
  object,
  xLab = "Percent reproducible sample pairs per feature",
  yLab = "Feature"
)
}
\arguments{
\item{object}{a Marr object from \code{Marr}}

\item{xLab}{label for x-axis.
Default is 'Percent reproducible sample pairs
per feature for pairwise replicates'.}

\item{yLab}{label for y-axis. Default is 'Feature'}
}
\value{
A histogram will be created showing the
features along the y-axis and percent reproducible sample pairs
per feature on the x-axis.
}
\description{
This function plots a histogram
showing the features along the y-axis
and percent reproducible sample pairs per feature on
the x-axis.
}
\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)
MarrPlotFeatures(data_Marr)

}
