% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{MarrFeatureVars}
\alias{MarrFeatureVars}
\alias{MarrFeatureVars,Marr-method}
\title{Generic function that returns the Marr Feature Vars}
\usage{
MarrFeatureVars(object)

\S4method{MarrFeatureVars}{Marr}(object)
}
\arguments{
\item{object}{an object of class \code{Marr}.}
}
\value{
Value of \code{featureVars} passed to \code{Marr}. NULL
if \code{featureVars} was left blank
}
\description{
Given a Marr object, this function returns the
Marr Feature Vars

Accessors for the 'MarrFeatureVars'
slot of a Marr object.
}
\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)
MarrFeatureVars(data_Marr)

}
