% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{counts_example}
\alias{counts_example}
\title{Gene Expression Counts for Marthandan et al. (2016) RNA-Seq Data}
\format{
A numeric matrix with rows as genes (gene symbols) and columns as
samples (sample IDs).
}
\source{
\url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE63577}
}
\usage{
data(counts_example)
}
\description{
A numeric matrix containing filtered and normalized (non log-transformed)
gene expression data from the Marthandan et al. (2016) study (GEO accession
GSE63577).
}
\details{
Raw FASTQ files were downloaded using \code{fasterq-dump} (v2.11.0) and processed
in a reproducible conda environment (Python v3.11.5). Quality control was
conducted using FastQC (v0.12.1) and summarised with MultiQC (v1.14).
Pseudo-alignment to the RefSeq transcriptome (NCBI release 109) was performed
using kallisto (v0.44.0). Genes with low expression (mean count < 70 in all
conditions) were filtered out. Count normalization factors were calculated
with \code{edgeR::calcNormFactors}.

Intermediate time points for HFF and MRC5 cell lines were excluded, resulting
in a final dataset with 45 high-quality samples across proliferative,
quiescent, and senescent conditions.

For illustration and package size reduction, genes with variance in the
bottom 10\% across samples were removed, retaining the 90\% most variable genes
in the dataset.
}
\references{
Marthandan S, Priebe S, Baumgart M, Groth M et al. Similarities
in Gene Expression Profiles during In Vitro Aging of Primary Human
Embryonic Lung and Foreskin Fibroblasts. \emph{Biomed Res Int} 2015;2015:731938.
PMID: 26339636

Marthandan S, Baumgart M, Priebe S, Groth M et al. Conserved
Senescence Associated Genes and Pathways in Primary Human Fibroblasts
Detected by RNA-Seq.
\emph{PLoS One} 2016;11(5):e0154531. PMID: 27140416
}
\keyword{datasets}
