% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Heatmap_Cohen.R
\name{Heatmap_Cohen}
\alias{Heatmap_Cohen}
\title{Generate Heatmaps for Cohen's d Effect Sizes using ggplot2}
\usage{
Heatmap_Cohen(
  cohenlist,
  nrow = NULL,
  ncol = NULL,
  limits = NULL,
  widthTitle = 22,
  titlesize = 12,
  ColorValues = NULL,
  title = NULL
)
}
\arguments{
\item{cohenlist}{A named list where each element corresponds to a gene
signature. Output of \code{CohenD_allConditions}. Each signature element is a
list with three components:
\describe{
\item{CohenD}{A data frame where rows are methods and columns are group contrasts
(formatted as "Group1:Group2"),
containing the computed Cohen\'s d effect sizes.}
\item{PValue}{A data frame with the same structure as \code{CohenD} containing
the corresponding p-values.}
\item{padj}{A data frame with the same structure as \code{PValue} containing the
corresponding p-values corrected using the BH method, for all signatures and contrasts,
and by method.}
}}

\item{nrow}{Optional. An integer specifying the number of rows in the heatmap
grid. If \code{NULL}, the number of rows is computed automatically.}

\item{ncol}{Optional. An integer specifying the number of columns in the
heatmap grid. If \code{NULL}, the number of columns is computed
automatically.}

\item{limits}{Optional. A numeric vector of length 2 specifying the color
scale limits (e.g., \code{c(min, max)}). If \code{NULL}, the limits are
determined from the data.}

\item{widthTitle}{An integer specifying the width used for wrapping gene set
signature names in the heatmap titles. Default is 22.}

\item{titlesize}{An integer specifying the text size for each of the heatmap
titles. Default is 12.}

\item{ColorValues}{A character vector specifying the colors for the gradient
fill in the heatmaps. Default is \code{c("#F9F4AE", "#B44141")}.}

\item{title}{Title for the grid of plots.}
}
\value{
A list with two elements:
\describe{
\item{plt}{A combined heatmap arranged in a grid using \code{ggpubr::ggarrange}.}
\item{data}{A list containing the Cohen\'s d effect sizes and p-values for each
gene signature, as computed by \code{CohenD_allConditions}.}
}
}
\description{
This function computes Cohen's d effect sizes and corresponding p-values for
multiple gene signatures and produces individual heatmaps. Each heatmap
displays cell text showing the Cohen's d value along with its p-value. The
heatmaps are then arranged in a grid layout.
}
\details{
The function first calculates Cohen\'s d effect sizes and
corresponding p-values for each gene signature using
\code{CohenD_allConditions} (assumed to be defined elsewhere in the package).
The resulting matrices are converted to a long format so that each cell in
the heatmap can display the Cohen\'s d value and its associated p-value
(formatted as \code{Cohen\'s d (p-value)}).

The heatmaps are then adjusted to display axis text and ticks only for the
left-most column and bottom row, and combined into a grid layout. If neither
\code{nrow} nor \code{ncol} are specified, the layout is automatically
determined to best approximate a square grid.
}
\seealso{
\code{\link{CohenD_allConditions}},
\code{\link{CohenF_allConditions}}
}
\keyword{internal}
