% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-shiftRanges.R
\name{shiftRanges}
\alias{shiftRanges}
\alias{shiftRanges,GRanges,character_OR_numeric-method}
\title{Flexibly shifting GRanges according to strand}
\usage{
shiftRanges(x, pos)

\S4method{shiftRanges}{GRanges,character_OR_numeric}(x, pos)
}
\arguments{
\item{x}{GRanges object}

\item{pos}{Position within anchors to resize the bin.
Can be a character or integer vector of length 1 or
`length(x)` designating the position for each element
in bedpe. Character options are "start", "end" and
"center". Integers are referenced from the start position
for '+' and '*' strands and from the end position
for the '-' strand.}
}
\value{
GRanges object with a single position range
 that has been shifted appropriately.
}
\description{
Flexibly shifting GRanges according to strand
}
\examples{
library(GenomicRanges)

## Create example GRanges
gr1 <- GRanges(seqnames = "chr1",
               ranges = IRanges::IRanges(start = rep(5000,3),
                                         end = rep(6000,3)),
               strand = c('+', '-', '*'))

gr2 <- gr1 |> promoters(upstream = 2000, downstream = 200)

## Shifting anchors by keyword
shiftRanges(gr1, 'start')
shiftRanges(gr1, 'end')
shiftRanges(gr1, 'center')

## Shifting anchors by position
shiftRanges(gr1, 100)
shiftRanges(gr1, c(100, 200, 300))

## Shifting back to TSS
shiftRanges(gr2, 2000)

}
