% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mariner.R
\docType{package}
\name{mariner-package}
\alias{mariner}
\alias{mariner-package}
\title{Mariner: Explore the Hi-Cs}
\description{
`mariner` is an R/Bioconductor package
for exploring Hi-C data. It enables users to
flexibly manipulate, extract, and aggregate
chromatin interaction data quickly and efficiently.
}
\details{
Key Features:
\itemize{
 \item Manipulating Paired Ranges - 
 Convert, bin, and shift paired genomic ranges.
 \item Clustering & Merging Interactions - 
 Group nearby interactions and select one as
 representative.
 \item Extracting & Aggregating Interactions - 
 Pull Hi-C pixels or matrices, then aggregate
 by files or interactions.
 \item Calculating Loop Enrichment - 
 Determine loop enrichment to local background
 with selection functions to flexibility select
 foreground and background.
}

For more details on the features of `mariner`, read
the vignette: `browseVignettes(package="mariner")`
}
\seealso{
Useful links:
\itemize{
  \item \url{https://ericscottdavis.com/mariner/}
  \item \url{https://github.com/EricSDavis/mariner}
}

}
\author{
\strong{Maintainer}: Eric Davis \email{ericscottdavis@outlook.com} (\href{https://orcid.org/0000-0003-4051-3217}{ORCID})

Authors:
\itemize{
  \item Sarah Parker \email{smp3800@gmail.com} (\href{https://orcid.org/0000-0002-2700-3979}{ORCID})
}

}
