% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-as_ginteractions.R
\name{as_ginteractions}
\alias{as_ginteractions}
\alias{makeGInteractionsFromDataFrame}
\alias{makeGInteractionsFromDataFrame,DF_OR_df_OR_dt,logical_OR_missing,logical_OR_missing-method}
\alias{as_ginteractions,DF_OR_df_OR_dt,logical_OR_missing,logical_OR_missing-method}
\title{Convert DataFrames to GInteraction objects}
\usage{
as_ginteractions(
  df,
  keep.extra.columns = TRUE,
  starts.in.df.are.0based = FALSE,
  ...
)

makeGInteractionsFromDataFrame(
  df,
  keep.extra.columns = TRUE,
  starts.in.df.are.0based = FALSE,
  ...
)

\S4method{makeGInteractionsFromDataFrame}{DF_OR_df_OR_dt,logical_OR_missing,logical_OR_missing}(df, keep.extra.columns, starts.in.df.are.0based)

\S4method{as_ginteractions}{DF_OR_df_OR_dt,logical_OR_missing,logical_OR_missing}(df, keep.extra.columns, starts.in.df.are.0based)
}
\arguments{
\item{df}{A data.table, data.frame, or DataFrame object.
Assumes that the first 6 colummns are in the format
chr1, start1, end1 and chr2, start2, end2, representing
each pair of interactions.}

\item{keep.extra.columns}{TRUE or FALSE (the default).
If TRUE, the columns in df that are not used to form
the genomic ranges of the returned GRanges object are
then returned as metadata columns on the object.
Otherwise, they are ignored. If df has a width column,
then it's always ignored.}

\item{starts.in.df.are.0based}{TRUE or FALSE (the default).
If TRUE, then the start positions of the genomic ranges
in df are considered to be 0-based and are converted to
1-based in the returned GRanges object. This feature is
intended to make it more convenient to handle input that
contains data obtained from resources using the
"0-based start" convention. A notorious example of such
resource is the UCSC Table Browser
(http://genome.ucsc.edu/cgi-bin/hgTables).}

\item{...}{Additional arguments.}
}
\value{
GInteraction object
}
\description{
`as_ginteractions` takes
a paired-interaction (i.e. BEDPE) formatted
data-frame-like object and converts it to a
GInteractions object. For convenience,
`makeGInteractionsFromDataFrame` can be used as an alias.
}
\examples{
## data.frame
df <- data.frame(chr1 = "chr1", x1 = 10000, x2 = 20000,
                 chr2 = "chr1", y1 = 30000, y2 = 40000)
makeGInteractionsFromDataFrame(df)

## data.frame
df <- data.frame(chr1 = "chr1", x1 = 10000, x2 = 20000,
                 chr2 = "chr1", y1 = 30000, y2 = 40000)
as_ginteractions(df)

## data.table
library(data.table)
df <- data.table::data.table(chr1 = "chr1", x1 = 10000, x2 = 20000,
                             chr2 = "chr1", y1 = 30000, y2 = 40000)
as_ginteractions(df)

## DataFrame
library(S4Vectors)
df <- DataFrame(chr1 = "chr1", x1 = 10000, x2 = 20000,
                chr2 = "chr1", y1 = 30000, y2 = 40000)
as_ginteractions(df)

## Alias
df <- data.frame(chr1 = "chr1", x1 = 10000, x2 = 20000,
                 chr2 = "chr1", y1 = 30000, y2 = 40000,
                 pval = 0.05, dist = 10000)
makeGInteractionsFromDataFrame(df)

## Additional metadata
df <- data.frame(chr1 = "chr1", x1 = 10000, x2 = 20000,
                 chr2 = "chr1", y1 = 30000, y2 = 40000,
                 pval = 0.05, dist = 10000)
as_ginteractions(df)

## Remove additional metadata
as_ginteractions(df, keep.extra.columns = FALSE)

## Add 1 to starts (for 0-based programs)
as_ginteractions(df, starts.in.df.are.0based = TRUE)

}
