% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-adjustEnrichment.R
\name{plotEnrichment}
\alias{plotEnrichment}
\alias{adjustEnrichment}
\alias{adjustEnrichment,DelayedMatrix_OR_matrix,GInteractions-method}
\alias{plotEnrichment,numeric,GInteractions-method}
\title{Adjust loop enrichment to remove distance-
dependent effect.}
\usage{
plotEnrichment(scores, interactions, k = 25, nknots = 10, plot = TRUE)

adjustEnrichment(x, interactions, k = 25, nknots = 10)

\S4method{adjustEnrichment}{DelayedMatrix_OR_matrix,GInteractions}(x, interactions, k = 25, nknots = 10)

\S4method{plotEnrichment}{numeric,GInteractions}(scores, interactions, k = 25, nknots = 10, plot = TRUE)
}
\arguments{
\item{scores}{Numeric vector of enrichment scores.}

\item{interactions}{A GInteractions Object containing
the interactions used to calculate enrichment scores.}

\item{k}{Number of observations for rolling window.}

\item{nknots}{integer or function giving the number
of knots to use see `?smooth.spline` for more info.}

\item{plot}{Boolean (default=FALSE), of whether to
show diagnostic plot.}

\item{x}{A DelayedMatrix or matrix with enrichment
scores.}
}
\value{
A DelayedMatrix of enrichment scores where rows
 are loops and columns are Hi-C files.

A plot (and associated data) for visualizing
 loop enrichment before and after distance adjustment.
}
\description{
Adjust loop enrichment to remove distance-
dependent effect.

Show diagnostic plot of loop enrichment before
and after distance adjustment.
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Read in loops as GInteractions object
loops <-
    WT_5kbLoops.txt() |>
    setNames("WT") |>
    read.table(header=TRUE, nrows=1000) |>
    as_ginteractions(keep.extra.columns=FALSE)

## Removes the "chr" prefix for compatibility
## with the preprocessed hic files
GenomeInfoDb::seqlevelsStyle(loops) <- 'ENSEMBL'

## Calculate loop enrichment
enrich <- calcLoopEnrichment(
    x=assignToBins(loops, 100e03),
    files=hicFiles
)

adjustEnrichment(enrich, loops)


plotEnrichment(enrich[,1], loops)

}
