% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRes.R
\name{plotRes}
\alias{plotRes}
\title{An individual Plot of power evaulation results under various scenarios.}
\usage{
plotRes(Power.list, depth_factor = 1, value_option = "FDR")
}
\arguments{
\item{Power.list}{A list produced by \code{\link{powerEval}}.}

\item{depth_factor}{A numerical value indicating which sequencing depth to plot. For example, 2 means doubling the original sequencing depth. Default is 1.}

\item{value_option}{A character indicating which measurement to plot. Options include "FDR", "FDC", "Power", and "Precision".}
}
\value{
It plots a certain power measurement of a certain sequencing depth. Power measurements to plot include "FDR", "FDC", "Power", and "Precision".
}
\description{
This function plots a certain power measurement of a certain sequencing depth. Power measurements to plot include "FDR", "FDC", "Power", and "Precision".
}
\examples{

library(magpie)
### Main function
power.test <- quickPower(dataset = "GSE46705", test_method = "TRESS")

### plot FDR under sequencing depth 1x
plotRes(power.test, depth_factor = 1, value_option = "FDR")

}
