% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segSummarize.R
\name{segSummarize}
\alias{segSummarize}
\title{Summarize CBS segmentation results}
\usage{
segSummarize(
  seg = NULL,
  build = "hg19",
  cytoband = NULL,
  thr = 0.3,
  verbose = TRUE,
  maf = NULL,
  genes = NULL,
  topanno = NULL,
  topannocols = NA
)
}
\arguments{
\item{seg}{segmentation results generated from \code{DNAcopy} package \code{\link{segment}}. Input should be a multi-sample segmentation file or a data.frame. First six columns should correspond to sample name, chromosome,  start,  end, Num_Probes, Segment_Mean in log2 scale. (default output format from DNAcopy)}

\item{build}{genome build. Default hg19. Can be hg19, hg38. If other than these, use `cytoband` argument}

\item{cytoband}{cytoband data from UCSC genome browser. Only needed if `build` is other than `hg19` or `hg38`}

\item{thr}{threshold to call amplification and deletion. Any cytobands or chromosomal arms with median logR above or below this will be called. Default 0.3}

\item{verbose}{Default TRUE}

\item{maf}{optional MAF}

\item{genes}{Add mutation status of these genes as an annotation to the heatmap}

\item{topanno}{annotation for each sample. This is passed as an input to `annotation_col` of `pheatmap`}

\item{topannocols}{annotation cols for `topanno`. This is passed as an input to `annotation_colors` of `pheatmap`}
}
\value{
List of median CN values for each cytoband and chromosomal arm along with the plotting matrix
}
\description{
Summarize CBS segmentation results
}
\details{
A handy function to summarize CBS segmentation results. Takes segmentation results generated by DNAcopy package \code{\link{segment}} and summarizes the CN for each cytoband and chromosomal arms.
}
\examples{
laml.seg <- system.file("extdata", "LAML_CBS_segments.tsv.gz", package = "maftools")
segSummarize(seg = laml.seg)

#Heighlight some genes as annotation
laml.maf = system.file("extdata", "tcga_laml.maf.gz", package = "maftools") #MAF file
laml.clin = system.file('extdata', 'tcga_laml_annot.tsv', package = 'maftools') #clinical data
laml = read.maf(maf = laml.maf, clinicalData = laml.clin)

segSummarize(seg = laml.seg, maf = laml, genes = c("FLT3", "DNMT3A"))
}
