% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSignatures.R
\name{plotSignatures}
\alias{plotSignatures}
\title{Plots decomposed mutational signatures}
\usage{
plotSignatures(
  nmfRes = NULL,
  contributions = FALSE,
  absolute = FALSE,
  color = NULL,
  patient_order = NULL,
  font_size = 0.6,
  show_title = TRUE,
  sig_db = "SBS_v34",
  axis_lwd = 1,
  title_size = 0.9,
  show_barcodes = FALSE,
  yaxisLim = NA,
  ...
)
}
\arguments{
\item{nmfRes}{results from \code{\link{extractSignatures}}}

\item{contributions}{If TRUE plots contribution of signatures in each sample.}

\item{absolute}{Whether to plot absolute contributions. Default FALSE.}

\item{color}{colors for each Ti/Tv conversion class. Default NULL}

\item{patient_order}{User defined ordering of samples. Default NULL.}

\item{font_size}{font size. Default 0.6}

\item{show_title}{If TRUE compares signatures to COSMIC signatures and prints them as title}

\item{sig_db}{Only applicable if show_title is TRUE. can be \code{legacy}, \code{SBS}, \code{SBS_v34}. Default \code{SBS_v34}}

\item{axis_lwd}{axis width. Default 1.}

\item{title_size}{size of title. Default 1.3}

\item{show_barcodes}{Default FALSE}

\item{yaxisLim}{Default NA.}

\item{...}{further plot options passed to \code{\link{barplot}}}
}
\value{
Nothing
}
\description{
Takes results from \code{\link{extractSignatures}} and plots decomposed mutational signatures as a barplot.
}
\seealso{
\code{\link{trinucleotideMatrix}} \code{\link{plotSignatures}}
}
