% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cbs_segs.R
\name{plotCBSsegments}
\alias{plotCBSsegments}
\title{Plots segmented copy number data.}
\usage{
plotCBSsegments(
  cbsFile = NULL,
  maf = NULL,
  tsb = NULL,
  savePlot = FALSE,
  ylims = NULL,
  seg_size = 0.1,
  width = 6,
  height = 3,
  genes = NULL,
  ref.build = "hg19",
  writeTable = FALSE,
  removeXY = FALSE,
  color = NULL
)
}
\arguments{
\item{cbsFile}{CBS segmented copy number file. Column names should be Sample, Chromosome, Start, End, Num_Probes and Segment_Mean (log2 scale).}

\item{maf}{optional \code{\link{MAF}}}

\item{tsb}{If segmentation file contains many samples (as in gistic input), specify sample name here.
Defualt plots head 1 sample. Set 'ALL' for plotting all samples. If you are maping maf, make sure sample names in
Sample column of segmentation file matches to those Tumor_Sample_Barcodes in MAF.}

\item{savePlot}{If true plot is saved as pdf.}

\item{ylims}{Default NULL}

\item{seg_size}{Default 0.1}

\item{width}{width of plot}

\item{height}{height of plot}

\item{genes}{If given and maf object is specified, maps all mutataions from maf onto segments. Default NULL}

\item{ref.build}{Reference build for chromosome sizes. Can be hg18, hg19 or hg38. Default hg19.}

\item{writeTable}{If true and if maf object is specified, writes plot data with each variant and its corresponding copynumber to an output file.}

\item{removeXY}{don not plot sex chromosomes.}

\item{color}{Manually specify color scheme for chromosomes. Default NULL. i.e, aletrnating Gray70 and midnightblue}
}
\value{
Draws plot
}
\description{
Plots segmented copy number data.
}
\details{
this function takes segmented copy number data and plots it. If MAF object is specified, all mutations are highlighted on the plot.
}
\examples{
tcga.ab.009.seg <- system.file("extdata", "TCGA.AB.3009.hg19.seg.txt", package = "maftools")
plotCBSsegments(cbsFile = tcga.ab.009.seg)

}
