% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mafSurvGroup.R
\name{mafSurvGroup}
\alias{mafSurvGroup}
\title{Performs survival analysis for a geneset}
\usage{
mafSurvGroup(
  maf,
  geneSet = NULL,
  minMut = NA,
  clinicalData = NULL,
  time = "Time",
  Status = "Status"
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{geneSet}{gene names for which survival analysis needs to be performed.}

\item{minMut}{minimum number of mutated genes in the `geneSet` to consider a sample as a mutant. Default, `NA`, samples with all the genes mutated are treated as mutant group.}

\item{clinicalData}{\code{dataframe} containing events and time to events. Default looks for clinical data in annotation slot of \code{\link{MAF}}.}

\item{time}{column name containing time in \code{clinicalData}}

\item{Status}{column name containing status of patients in \code{clinicalData}. must be logical or numeric. e.g, TRUE or FALSE, 1 or 0.}
}
\value{
Survival plot
}
\description{
Similar to \code{\link{mafSurvival}} but for a geneset
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml.clin <- system.file("extdata", "tcga_laml_annot.tsv", package = "maftools")
laml <- read.maf(maf = laml.maf,  clinicalData = laml.clin)
mafSurvGroup(maf = laml, geneSet = c('DNMT3A', 'FLT3'), time = 'days_to_last_followup', Status = 'Overall_Survival_Status')
}
