% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisticOncoPlot.R
\name{gisticOncoPlot}
\alias{gisticOncoPlot}
\title{Plot gistic results.}
\usage{
gisticOncoPlot(
  gistic = NULL,
  top = NULL,
  bands = NULL,
  showTumorSampleBarcodes = FALSE,
  gene_mar = 5,
  barcode_mar = 6,
  right_mar = 2.5,
  sepwd_genes = 0.5,
  sepwd_samples = 0.25,
  clinicalData = NULL,
  clinicalFeatures = NULL,
  sortByAnnotation = FALSE,
  sampleOrder = NULL,
  annotationColor = NULL,
  bandsToIgnore = NULL,
  removeNonAltered = TRUE,
  colors = NULL,
  SampleNamefontSize = 0.6,
  fontSize = 0.8,
  legendFontSize = 1.2,
  annotationFontSize = 1.2,
  borderCol = "white",
  bgCol = "#CCCCCC"
)
}
\arguments{
\item{gistic}{an \code{\link{GISTIC}} object generated by \code{\link{readGistic}}}

\item{top}{how many top cytobands to be drawn. defaults to all.}

\item{bands}{draw oncoplot for these bands. Default NULL.}

\item{showTumorSampleBarcodes}{logical to include sample names.}

\item{gene_mar}{Default 5}

\item{barcode_mar}{Default 6}

\item{right_mar}{Default 2.5}

\item{sepwd_genes}{Default 0.5}

\item{sepwd_samples}{Default 0.25}

\item{clinicalData}{data.frame with columns containing Tumor_Sample_Barcodes and rest of columns with annotations.}

\item{clinicalFeatures}{columns names from `clinicalData` to be drawn in the plot. Dafault NULL.}

\item{sortByAnnotation}{logical sort oncomatrix (samples) by provided `clinicalFeatures`. Defaults to FALSE. column-sort}

\item{sampleOrder}{Manually speify sample names for oncolplot ordering. Default NULL.}

\item{annotationColor}{list of colors to use for clinicalFeatures. Default NULL.}

\item{bandsToIgnore}{do not show these bands in the plot Default NULL.}

\item{removeNonAltered}{Logical. If \code{TRUE} removes samples with no mutations in the oncoplot for better visualization. Default \code{FALSE}.}

\item{colors}{named vector of colors Amp and Del events.}

\item{SampleNamefontSize}{font size for sample names. Default 0.6}

\item{fontSize}{font size for cytoband names. Default 0.8}

\item{legendFontSize}{font size for legend. Default 1.2}

\item{annotationFontSize}{font size for annotations. Default 1.2}

\item{borderCol}{Default "white"}

\item{bgCol}{Default "#CCCCCC"}
}
\value{
None.
}
\description{
takes output generated by readGistic and draws a plot similar to oncoplot.
}
\details{
Takes gistic file as input and plots it as a matrix. Any desired annotations can be added at the bottom of the oncoplot by providing \code{annotation}
}
\examples{
all.lesions <- system.file("extdata", "all_lesions.conf_99.txt", package = "maftools")
amp.genes <- system.file("extdata", "amp_genes.conf_99.txt", package = "maftools")
del.genes <- system.file("extdata", "del_genes.conf_99.txt", package = "maftools")
scores.gistic <- system.file("extdata", "scores.gistic", package = "maftools")
laml.gistic = readGistic(gisticAllLesionsFile = all.lesions, gisticAmpGenesFile = amp.genes, gisticDelGenesFile = del.genes, gisticScoresFile = scores.gistic)
gisticOncoPlot(laml.gistic)
}
\seealso{
\code{\link{oncostrip}}
}
