% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snpMatrix.R
\name{genotypeMatrix}
\alias{genotypeMatrix}
\title{Creates a Genotype Matrix for every variant}
\usage{
genotypeMatrix(
  maf,
  genes = NULL,
  tsb = NULL,
  includeSyn = FALSE,
  vafCol = NULL,
  vafCutoff = c(0.1, 0.75)
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{genes}{create matrix for only these genes. Define NULL}

\item{tsb}{create matrix for only these tumor sample barcodes/samples. Define NULL}

\item{includeSyn}{whether to include silent mutations. Default FALSE}

\item{vafCol}{specify column name for vaf's. Default NULL. If not provided simply assumes all mutations are heterozygous.}

\item{vafCutoff}{specify minimum and maximum vaf to define mutations as heterozygous. Default range 0.1 to 0.75. Mutations above maximum vafs are defined as homozygous.}
}
\value{
matrix
}
\description{
Creates a Genotype matrix using allele frequcies or by muatation status.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
genotypeMatrix(maf = laml, genes = "RUNX1")

}
