% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coOncoplot.R
\name{coOncoplot}
\alias{coOncoplot}
\title{Draw two oncoplots side by side for cohort comparision.}
\usage{
coOncoplot(
  m1,
  m2,
  genes = NULL,
  m1Name = NULL,
  m2Name = NULL,
  clinicalFeatures1 = NULL,
  clinicalFeatures2 = NULL,
  annotationColor1 = NULL,
  annotationColor2 = NULL,
  annotationFontSize = 1.2,
  sortByM1 = FALSE,
  sortByM2 = FALSE,
  sortByAnnotation1 = FALSE,
  annotationOrder1 = NULL,
  sortByAnnotation2 = FALSE,
  annotationOrder2 = NULL,
  sampleOrder1 = NULL,
  sampleOrder2 = NULL,
  additionalFeature1 = NULL,
  additionalFeaturePch1 = 20,
  additionalFeatureCol1 = "white",
  additionalFeatureCex1 = 0.9,
  additionalFeature2 = NULL,
  additionalFeaturePch2 = 20,
  additionalFeatureCol2 = "white",
  additionalFeatureCex2 = 0.9,
  sepwd_genes1 = 0.5,
  sepwd_samples1 = 0.5,
  sepwd_genes2 = 0.5,
  sepwd_samples2 = 0.5,
  colors = NULL,
  removeNonMutated = TRUE,
  anno_height = 2,
  legend_height = 4,
  geneNamefont = 0.8,
  showSampleNames = FALSE,
  SampleNamefont = 0.5,
  barcode_mar = 1,
  outer_mar = 3,
  gene_mar = 1,
  legendFontSize = 1.2,
  titleFontSize = 1.5,
  keepGeneOrder = FALSE,
  bgCol = "#ecf0f1",
  borderCol = "white"
)
}
\arguments{
\item{m1}{first \code{\link{MAF}} object}

\item{m2}{second \code{\link{MAF}} object}

\item{genes}{draw these genes. Default plots top 5 mutated genes from two cohorts.}

\item{m1Name}{optional name for first cohort}

\item{m2Name}{optional name for second cohort}

\item{clinicalFeatures1}{columns names from `clinical.data` slot of m1 \code{MAF} to be drawn in the plot. Dafault NULL.}

\item{clinicalFeatures2}{columns names from `clinical.data` slot of m2 \code{MAF} to be drawn in the plot. Dafault NULL.}

\item{annotationColor1}{list of colors to use for `clinicalFeatures1` Default NULL.}

\item{annotationColor2}{list of colors to use for `clinicalFeatures2` Default NULL.}

\item{annotationFontSize}{font size for annotations Default 1.2}

\item{sortByM1}{sort by mutation frequency in `m1`}

\item{sortByM2}{sort by mutation frequency in `m2`}

\item{sortByAnnotation1}{logical sort oncomatrix (samples) by provided `clinicalFeatures1`. Sorts based on first `clinicalFeatures1`.  Defaults to FALSE. column-sort}

\item{annotationOrder1}{Manually specify order for annotations for `clinicalFeatures1`. Works only for first value. Default NULL.}

\item{sortByAnnotation2}{same as above but for m2}

\item{annotationOrder2}{Manually specify order for annotations for `clinicalFeatures2`. Works only for first value. Default NULL.}

\item{sampleOrder1}{Manually specify sample names in m1 for oncolplot ordering. Default NULL.}

\item{sampleOrder2}{Manually specify sample names in m2 for oncolplot ordering. Default NULL.}

\item{additionalFeature1}{a vector of length two indicating column name in the MAF and the factor level to be highlighted.}

\item{additionalFeaturePch1}{Default 20}

\item{additionalFeatureCol1}{Default "white"}

\item{additionalFeatureCex1}{Default 0.9}

\item{additionalFeature2}{a vector of length two indicating column name in the MAF and the factor level to be highlighted.}

\item{additionalFeaturePch2}{Default 20}

\item{additionalFeatureCol2}{Default "white"}

\item{additionalFeatureCex2}{Default 0.9}

\item{sepwd_genes1}{Default 0.5}

\item{sepwd_samples1}{Default 0.5}

\item{sepwd_genes2}{Default 0.5}

\item{sepwd_samples2}{Default 0.5}

\item{colors}{named vector of colors for each Variant_Classification.}

\item{removeNonMutated}{Logical. If \code{TRUE} removes samples with no mutations in the oncoplot for better visualization. Default \code{TRUE}.}

\item{anno_height}{Height of clinical margin. Default 2}

\item{legend_height}{Height of legend margin. Default 4}

\item{geneNamefont}{font size for gene names. Default 1}

\item{showSampleNames}{whether to show sample names. Defult FALSE.}

\item{SampleNamefont}{font size for sample names. Default 0.5}

\item{barcode_mar}{Margin width for sample names. Default 1}

\item{outer_mar}{Margin width for outer. Default 3}

\item{gene_mar}{Margin width for gene names. Default 1}

\item{legendFontSize}{font size for legend. Default 1.2}

\item{titleFontSize}{font size for title. Default 1.5}

\item{keepGeneOrder}{force the resulting plot to use the order of the genes as specified. Default FALSE}

\item{bgCol}{Background grid color for wild-type (not-mutated) samples. Default gray - "#CCCCCC"}

\item{borderCol}{border grid color for wild-type (not-mutated) samples. Default 'white'}
}
\value{
Invisibly returns a list of sample names in their order of occurrences in M1 and M2 respectively.
}
\description{
Draw two oncoplots side by side for cohort comparision.
}
\details{
Draws two oncoplots side by side to display difference between two cohorts.
}
\examples{
#' ##Primary and Relapse APL
primary.apl <- system.file("extdata", "APL_primary.maf.gz", package = "maftools")
relapse.apl <- system.file("extdata", "APL_relapse.maf.gz", package = "maftools")
##Read mafs
primary.apl <- read.maf(maf = primary.apl)
relapse.apl <- read.maf(maf = relapse.apl)
##Plot
coOncoplot(m1 = primary.apl, m2 = relapse.apl, m1Name = 'Primary APL', m2Name = 'Relapse APL')
dev.off()
}
