% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/loci2pathResult-methods.R
\docType{methods}
\name{getTissueDegree}
\alias{getTissueDegree}
\alias{getTissueDegree,loci2pathResult-method}
\title{Extract tissue degree from query result}
\usage{
getTissueDegree(res, ...)

\S4method{getTissueDegree}{loci2pathResult}(res, loci)
}
\arguments{
\item{res}{query result from function query.egset.list()}

\item{\dots}{additional params}

\item{loci}{a list of eqtlSet; each member should be an eqtlSet
object}
}
\value{
\item{gene.tissue.map}{shows mapping:gene<->tissue}
\item{gene.tissue.degree}{shows tissue degree for each gene}
\item{mean.tissue.degree}{shows the average tissue digree for each pathway
 in the result table}
}
\description{
This function extracts the tissue degree from eQTL list query result for
each pathway.
}
\examples{
result <- query(query.gr=query.gr, 
  loci=eset.list, path=biocarta)
tissue.degree=getTissueDegree(result, eset.list)
head(tissue.degree$gene.tissue.map)
head(tissue.degree$gene.tissue.degree)
head(tissue.degree$mean.tissue.degree)
}
\keyword{result}
