% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{filterLinks,linkSet-method}
\alias{filterLinks,linkSet-method}
\alias{filterLinks}
\title{Filter links for further analysis}
\usage{
\S4method{filterLinks}{linkSet}(x, filter_intra = TRUE, filter_unannotate = TRUE, distance = NULL)
}
\arguments{
\item{x}{A linkSet object}

\item{filter_intra}{Whether to filter intra-chromosomal interactions}

\item{filter_unannotate}{Whether to filter unannotated interactions}

\item{distance}{The maximum distance between bait and other end}
}
\value{
A linkSet object with filtered interactions
}
\description{
Filter links for further analysis
}
\examples{
data(linkExample)
linkSet = c(linkExample,linkExample)
linkSet = countInteractions(linkSet)
linkSet = filterLinks(linkSet, filter_intra = FALSE, filter_unannotate = FALSE, distance = 100000)
}
