% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_vcf.R
\name{merge_vcf}
\alias{merge_vcf}
\title{merge_vcf}
\usage{
merge_vcf(vcf_fls = NULL, vcf_folder = NULL, gff3_path = NULL)
}
\arguments{
\item{vcf_fls}{A list of paths to VCF files}

\item{vcf_folder}{A path to a folder containing all VCF file that
will be integrated into a single table}

\item{gff3_path}{Path to GFF3 file}
}
\value{
A data table contaiing all variants from each sample of the input VCF files
}
\description{
Merge Variant Calling Format (VCF) files into a single tab-delimited table
}
\examples{

merge_vcf(
    vcf_folder = system.file("extdata",
        "vcf-files",
        package = "lineagespot"
    ),
    gff3_path = system.file("extdata",
        "NC_045512.2_annot.gff3",
        package = "lineagespot"
    )
)
}
