% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpLoading2dPlot.R
\name{lmpLoading2dPlot}
\alias{lmpLoading2dPlot}
\title{Loading plots on a 2D scatter plot}
\usage{
lmpLoading2dPlot(
  resLmpPcaEffects,
  effectNames = NULL,
  axes = c(1, 2),
  addRownames = FALSE,
  pl_n = 10,
  metadata = NULL,
  drawOrigin = TRUE,
  ...
)
}
\arguments{
\item{resLmpPcaEffects}{A list corresponding to the output value of \code{\link{lmpPcaEffects}}.}

\item{effectNames}{Names of the effects to be plotted. If \code{NULL}, all the effects are plotted.}

\item{axes}{A numerical vector with the 2 Principal Components axes to be drawn.}

\item{addRownames}{Boolean indicating if the labels should be plotted. By default, uses the column names of the outcome matrix but it can be manually specified with the \code{points_labs} argument from \code{\link{plotScatter}}.}

\item{pl_n}{The number of labels that should be plotted, based on the distance measure \eqn{d} (\emph{see} Details).}

\item{metadata}{A nxk "free encoded" data.frame corresponding to \code{design} in \code{\link{plotScatter}}.}

\item{drawOrigin}{if \code{TRUE}, draws horizontal and vertical intercepts at (0,0) based on the \code{\link{plotScatter}} function.}

\item{...}{Additional arguments to be passed to \code{\link{plotScatter}}.}
}
\value{
A list of loading plots (ggplot).
}
\description{
Draws a 2D loading plot of each effect matrix provided in \code{\link{lmpPcaEffects}} outputs. As a wrapper of the \code{\link{plotScatter}} function, it allows the visualization of effect loading matrices for two components at a time with all options available in \code{\link{plotScatter}}.
}
\details{
\code{lmpLoading2dPlot} is a wrapper of \code{\link{plotScatter}}. See \code{?plotScatter} for more information on the additional arguments.

The distance measure \eqn{d}{d} that is used to rank the variables is based on the following formula:
\deqn{d = \sqrt(P_{ab}^2*\lambda_{ab}^2)}{d = sqrt(P_ab^2 * lambda_ab^2)} where \eqn{a}{a}
and \eqn{b}{b} are two selected Principal Components, \eqn{P_{ab}}{P_ab} represents their
loadings and \eqn{\lambda_{ab}}{lambda_ab} their singular values.
}
\examples{

data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
resLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)
resASCA <- lmpPcaEffects(resLmpEffectMatrices)

lmpLoading2dPlot(resASCA, effectNames = "Hippurate")

# adding color, shape and labels to points
id_hip <- c(seq(126, 156), seq(362, 375))
peaks <- rep("other", ncol(UCH$outcomes))
peaks[id_hip] <- "hip"
metadata <- data.frame(peaks)

lmpLoading2dPlot(resASCA,
  effectNames = "Hippurate",
  metadata = metadata, addRownames = TRUE, color = "peaks",
  shape = "peaks"
)

# changing max.overlaps of ggrepel
options(ggrepel.max.overlaps = 30)
lmpLoading2dPlot(resASCA,
  effectNames = "Hippurate",
  metadata = metadata, addRownames = TRUE, color = "peaks",
  shape = "peaks", pl_n = 20
)

}
