% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.gof.R
\name{model.gof-deprecated}
\alias{model.gof-deprecated}
\title{LFA model goodness of fit}
\usage{
model.gof(X, LF, B)
}
\arguments{
\item{X}{A matrix of SNP genotypes, i.e. an integer matrix of 0's,
1's, 2's and \code{NA}s.
BEDMatrix is supported.}

\item{LF}{matrix of logistic factors}

\item{B}{number of null datasets to generate, \code{B = 1} is usually
sufficient. If computational time/power allows, a few extra
\code{B} could be helpful}
}
\value{
vector of p-values for each SNP.
}
\description{
Compute SNP-by-SNP goodness-of-fit when compared to population
structure. This can be aggregated to determine genome-wide
goodness-of-fit for a particular value of \code{d}.
}
\details{
This function returns p-values for LFA model goodness of fit based
on a simulated null.
}
\note{
Genotype matrix is expected to be a matrix of integers with
values 0, 1, and 2. Currently no support for missing values. Note
that the coding of the SNPs does not affect the algorithm.
}
\seealso{
\code{\link[=lfa-deprecated]{lfa-deprecated()}}
}
\keyword{internal}
