% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{relativeAb}
\alias{relativeAb}
\title{Utility function to calculate relative abundances}
\usage{
relativeAb(se, assay = 1L)
}
\arguments{
\item{se}{A \link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}
object with counts}

\item{assay}{The i-th assay matrix in the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
('relab'; #' default 1).}
}
\value{
returns a new
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}
object with counts per million calculated and added as a new assay named rel_abs.
}
\description{
The function calculates the column totals and divides each value within the
column by the respective column total.

This function calculates the relative abundance of each feature in the
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}
object containing count data, expressed as counts per million (CPM)
}
\examples{

se <- SummarizedExperiment(
    assays = list(
        counts = matrix(
            rep(1, 4), ncol = 1, dimnames = list(LETTERS[1:4], "SAMP")
        )
    )
)
assay(se)
assay(relativeAb(se))

}
