% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictsvm-methods.R, R/trainsvm-methods.R
\docType{methods}
\name{predictSVM}
\alias{predictSVM}
\alias{predictSVM,ExpicitRepresentation-method}
\alias{predictSVM,ExplicitRepresentation-method}
\alias{predictSVM,KernelMatrix-method}
\alias{predictSVM,missing-method}
\alias{predictSVM.KernelMatrix}
\alias{trainSVM}
\alias{trainSVM,ExplicitRepresentation-method}
\alias{trainSVM,KernelMatrix-method}
\title{SVM Access for Training and Prediction}
\usage{
predictSVM.KernelMatrix(x, model, predictionType, verbose, ...)

\S4method{predictSVM}{missing}(x, model, predictionType, verbose, ...)

\S4method{predictSVM}{ExplicitRepresentation}(x, model, predictionType, verbose,
  ...)

\S4method{trainSVM}{KernelMatrix}(x, y = NULL, svmInfo, verbose, ...)

\S4method{trainSVM}{ExplicitRepresentation}(x, y = NULL, svmInfo, verbose,
  ...)
}
\arguments{
\item{x}{kernel matrix or explicit representation}

\item{model}{KeBABS model}

\item{predictionType}{type of prediction}

\item{verbose}{controlling verbosity}

\item{...}{additional arguments to be passed to the selected SVM}

\item{y}{label vector}

\item{svmInfo}{SVM related info}
}
\value{
\code{trainSVM:} returns the SVM specific model\cr\cr
\code{predictSVM:} returns the prediction in native format
}
\description{
Functions for SVM access (used only for testing purpose)
}
\details{
These methods are exported only for test purpose and are not meant
to be generally used.
}
\examples{
## this function is exported only for testing purpose
## use function kbsvm instead for examples see help page of kbsvm
data(TFBS)
}
\author{
Johannes Palme
}
\references{
\url{https://github.com/UBod/kebabs}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576.
DOI: \doi{10.1093/bioinformatics/btv176}.
}
