% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpSegments.R
\name{kpSegments}
\alias{kpSegments}
\title{kpSegments}
\usage{
kpSegments(karyoplot, data=NULL, chr=NULL, x0=NULL, x1=NULL, y0=NULL, y1=NULL, ymin=NULL, ymax=NULL, data.panel=1, r0=NULL, r1=NULL,  clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with the data. If \code{data} is present, \code{chr} will be set to \code{seqnames(data)}, \code{x0} to \code{start(data)} and x1 to \code{end(data)}. If no parameter \code{y0} is specified and \code{data} has a column named \code{y0}, this column will be used. The same for \code{y1}. (defaults to NULL)}

\item{chr}{(a charecter vector) A vector of chromosome names specifying the chromosomes of the data points. If \code{data} is not NULL, \code{chr} is ignored. (defaults to NULL)}

\item{x0}{(a numeric vector) A numeric vector of x left positions (in base pairs). If \code{data} is not NULL, \code{x0}. (defaults to NULL)}

\item{x1}{(a numeric vector) A numeric vector of x right positions (in base pairs). If \code{data} is not NULL, \code{x1}. (defaults to NULL)}

\item{y0}{(a numeric vector) A numeric vector of y bottom positions. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{y1}{(a numeric vector) A numeric vector of y top positions. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{ymin}{(numeric) The minimum value of \code{y} to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to NULL)}

\item{ymax}{(numeric) The maximum value of \code{y} to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Plots segments at the specified genomic positions.
}
\details{
This is one of the functions from karyoploteR implementing the adaptation to the genome context 
of basic plot functions from R base graphics. 
Given a set of positions on the genome (chromosome, x0 and x1) and values 
(y0 and y1) for each of them, it plots segments going from (x0, y0) to (x1, y1). Data can be 
provided via a \code{GRanges} object (\code{data}), independent parameters for chr, 
x0, x1, y0 and y1, or a combination of both.
A number of parameters can be used to define exactly where and how the segments are drawn.
In addition, via the ellipsis operator (\code{...}), \code{kpSegments} accepts any parameter 
valid for \code{segments} (e.g. \code{lwd}, \code{lty}, \code{col}, ...)
}
\examples{
 
set.seed(1000)
data.points <- sort(createRandomRegions(nregions=500, length.mean=2000000, mask=NA))
y <- runif(500, min=0, max=0.8)
mcols(data.points) <- data.frame(y0=y, y1=y+0.2)

kp <- plotKaryotype("hg19", plot.type=2, chromosomes=c("chr1", "chr2"))
  kpDataBackground(kp, data.panel=1)
  kpDataBackground(kp, data.panel=2)

  kpRect(kp, data=data.points, col="black")
  kpSegments(kp, data=data.points, col="white")
  
  kpSegments(kp, data=data.points, y0=0, y1=1,  r0=0.2, r1=0.8, col="lightblue", data.panel=2)
  kpSegments(kp, data=data.points, y0=0, y1=1,  r0=0.8, r1=0.2, col="lightgreen", data.panel=2)
  

 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpRect}}, \code{\link{kpPoints}}

\code{\link{kpPlotRegions}}
}
