% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPlotNames.R
\name{kpPlotNames}
\alias{kpPlotNames}
\title{kpPlotNames}
\usage{
kpPlotNames(karyoplot, data=NULL, chr=NULL, x0=NULL, x1=x0, y0=NULL, y1=NULL, labels=NULL, position="left", ymax=NULL, ymin=NULL, r0=NULL, r1=NULL,  data.panel=1, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with the data. If \code{data} is present, \code{chr} will be set to \code{seqnames(data)}, \code{x0} to \code{start(data)} and x1 to \code{end(data)}. If no parameter \code{y0} is specified and \code{data} has a column named \code{y0}, this column will be used. The same for \code{y1}. (defaults to NULL)}

\item{chr}{(a charecter vector) A vector of chromosome names specifying the chromosomes of the data points. If \code{data} is not NULL, \code{chr} is ignored. (defaults to NULL)}

\item{x0}{(a numeric vector) A numeric vector of x left positions (in base pairs). If \code{data} is not NULL, \code{x0}. (defaults to NULL)}

\item{x1}{(a numeric vector) A numeric vector of x right positions (in base pairs). If \code{data} is not NULL, \code{x1}. (defaults to NULL)}

\item{y0}{(a numeric vector) A numeric vector of y bottom positions. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{y1}{(a numeric vector) A numeric vector of y top positions. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{labels}{(character) The labels to use in the plot. They will be associated to the rectangles by its order and recycled as needed.}

\item{position}{(character) The position of the text relative to the rectangle. Can be "left", "right", "top", "bottom" or "center". Defaults to "left".}

\item{ymax}{(numeric) The maximum value of \code{y} to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to NULL)}

\item{ymin}{(numeric) The minimum value of \code{y} to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to NULL)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Plots text labels with positioning relative to rectangles along the genome.
}
\details{
This is a simple wrapper around \code{\link{kpText}} that positions the 
 text relative to the rectangles defined by its arguments. They may be
 used to name or label different graphical elements in the plot.
 The rectangles may be specified as in \code{\link{kpRect}} the relative 
 positions accepted are: "left", "right", "top", "bottom", "center". 
 It is possible to specify and empty label (\code{labels=""}) to leave an
 element without name.
}
\examples{
 
 
 regs <- toGRanges(data.frame(chr=c("chr1", "chr1", "chr1"),
                  start=c(20e6, 100e6, 200e6),
                  end=c(40e6, 170e6, 210e6),
                  y0=c(0.1, 0.5, 0.7),
                  y1=c(0.5, 0.6, 0.95)))
 
 kp <- plotKaryotype(genome="hg19", chromosomes="chr1")
 kpRect(kp, data=regs)  
 
 kpPlotNames(kp, data=regs, labels=c("R1", "R2", "R3"))
 kpPlotNames(kp, data=regs, labels=c("R1", "R2", "R3"), position="top", cex=2)    
 kpPlotNames(kp, data=regs, labels=c("R1", "", "R3"), position="right", col="red")
 kpPlotNames(kp, data=regs, labels="bottom", position="bottom", col=rainbow(3))
 kpPlotNames(kp, data=regs, labels="o", position="center", col=rainbow(3), cex=1)                
 
}
\seealso{
\code{\link{kpText}}, \code{\link{kpRect}}
}
