% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPlotLinks.R
\name{kpPlotLinks}
\alias{kpPlotLinks}
\title{kpPlotLinks}
\usage{
kpPlotLinks(karyoplot, data, data2=NULL, y=0, arch.height=NULL, data.panel=1, r0=NULL, r1=NULL, ymin=NULL, ymax=NULL, col="#8e87eb", border=NULL, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with link start regions. If data2 is NULL, mcols(data) should be a bed-like structure with "link.chr", "link.start", "link.end" and optionally a "link.strand" columns. The first thee columns can have any name and the strand information will be extracted from the first column with "strand" in its name.}

\item{data2}{(a \code{GRanges}) A GRanges object with the link end regions. If null, the end of the regions will be extracted from mcols(data). (Defaults to NULL)}

\item{y}{(numeric) The y value where the origin and end of the links should be plotted (Defaults to 0)}

\item{arch.height}{(numeric) The approximate arch height in links in the same chromosome in "y" scale. If NULL, it defaults to the whole span of the data panel.Also affects the curvature of links between chromosomes (Defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{ymin}{(numeric) The minimum value to be plotted on the data panel. If NULL, it is set to 0. (deafults to NULL)}

\item{ymax}{(numeric) The maximum value to be plotted on the data.panel. If NULL the maximum density is used. (defaults to NULL)}

\item{col}{(color) The background color of the links. If NULL and border is specified, it defaults to a lighter version of border.}

\item{border}{(color) The border color of the links. If NULL and col is specified, it defaults to a darker version of col.}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Given 2 \code{GRanges} objects, plot lines or ribbons between region pairs
}
\details{
This is one of the high-level, or specialized, plotting functions of karyoploteR.
 It takes two \code{GRanges} objects (or a single specially crafted one) and
 plots links (either lines or ribbons) between region pairs. Links are 
 plotted bewteen the first region of both objects, between the second one, etc...
 and therefore both objects need to have the same length. Specifying a region
 as negative strand, will "flip" it, so the the start of a region can be 
 linked to the end of its pair.
}
\note{
For a link to be plotted BOTH ends must be visible in the karyoplot. In 
  particular, if a chromosome is not included in the plot (due to not
  being specified in \code{chromosomes}, for example) any link with an end
  on it will NOT be plotted. The same is true for zoomed in plots, where only
  intrachromosomal links will be visible. No warning or message will be
  generated.
}
\examples{
 
 
 set.seed(222)
 
 starts <- sort(createRandomRegions(nregions = 15))
 ends <- sort(createRandomRegions(nregions = 15))
 
 kp <- plotKaryotype()
 kpPlotLinks(kp, data=starts, data2=ends)
 
 #Create larger regions, so they look like ribbons
 starts <- sort(createRandomRegions(nregions = 15, length.mean = 8e6, length.sd = 5e6))
 ends <- sort(createRandomRegions(nregions = 15, length.mean = 8e6, length.sd = 5e6))
 
 kp <- plotKaryotype()
 kpPlotLinks(kp, data=starts, data2=ends)
 
 #flip some of them to represent inversions
 strand(ends) <- sample(c("+", "-"), length(ends), replace = TRUE)
 
 kp <- plotKaryotype()
 kpPlotLinks(kp, data=starts, data2=ends)
 

}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpPlotRibbon}}, \code{\link{kpSegments}}
}
