% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{filterParams}
\alias{filterParams}
\title{filterParams}
\usage{
filterParams(p, valid.elements, orig.length)
}
\arguments{
\item{p}{a list or a single vector}

\item{valid.elements}{a boolean vector with the elements to keep}

\item{orig.length}{the length of the elements on which to apply the filtering}
}
\value{
p with some members filtered
}
\description{
Given a list, select just only the valid.elements from each member. Also 
works with vectors instead of lists
}
\details{
This function is used in filtering the graphical parameters when plotting
only a part of the genome. For each element of the list, if it has the 
exact specified length, filters it using the 'valid.elements' parameter.
}
\examples{
 
a <- 1:10
b <- 3:5
c <- 2

filterParams(list(a,b,c), c(rep(TRUE,5), rep(FALSE,5)), 10)
filterParams(a, c(rep(TRUE,5), rep(FALSE,5)), 10)
 
}
