% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{getRefLimma}
\alias{getRefLimma}
\title{provide access to a limma analysis of RNA-seq profiles for reference histology samples}
\usage{
getRefLimma()
}
\value{
an instance of \code{\link[limma:marraylm]{MArrayLM-class}} representing regularized gene-wise ANOVAs
}
\description{
provide access to a limma analysis of RNA-seq profiles for reference histology samples
}
\note{
Uses \code{\link[utils]{download.file}} to acquire RDS of the output
of \code{\link[limma]{eBayes}} from a public S3 bucket.  The limma model
was fit using \code{\link[limma:dupcor]{duplicateCorrelation}} to address multiplicity
of contributions per donor.  Comparisons are to samples labeled \code{CT-reference} (cellular tumor, reference contributions),
with coefficients 2-5 corresponding to CT-mvp (microvascular proliferation),
CT-pan (pseudopalisading cells around necrosis), IT (infiltrating tumor),
and LE (leading edge), respectively.
}
\examples{
requireNamespace("limma")
ebout = getRefLimma() # is result of eBayes
colnames(ebout$coef)
limma::topTable(ebout,2)
}
