% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isomiRs.R
\name{isoDE}
\alias{isoDE}
\title{Differential expression analysis with DESeq2}
\usage{
isoDE(ids, formula = NULL, ...)
}
\arguments{
\item{ids}{Object of class \link{IsomirDataSeq}.}

\item{formula}{Formula used for DE analysis.}

\item{...}{Options to pass to \code{\link[=isoCounts]{isoCounts()}} including
ref, iso5, iso3, add, subs and seed parameters.}
}
\value{
\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet} object.
To get the differential expression isomiRs, use \code{\link[DESeq2:results]{DESeq2::results()}} from
DESeq2 package. This allows to ask for different contrast
without calling again \code{\link[=isoDE]{isoDE()}}. Read \code{results}
manual to know how to access all the information.
}
\description{
This function does differential expression analysis with
\link[DESeq2:DESeq2-package]{DESeq2::DESeq2-package} using the specific formula.
It will return a \link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet} object.
}
\details{
First, this function collapses all isomiRs in different types.
Read more at \code{\link[=isoCounts]{isoCounts()}} to know the different options
available to collapse isomiRs.

After that, \link[DESeq2:DESeq2-package]{DESeq2::DESeq2-package} is used to do differential
expression analysis. It uses the count matrix and design experiment
stored at (\code{counts(ids)} and \code{colData(ids)})
\link{IsomirDataSeq} object
to construct a \link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet} object.
}
\examples{
data(mirData)
ids <- isoCounts(mirData, minc=10, mins=6)
dds <- isoDE(mirData, formula=~condition)
}
