% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{IsomirDataSeqFromRawData}
\alias{IsomirDataSeqFromRawData}
\title{Loads miRNA annotation from seqbuster tool or pre-processed data.}
\usage{
IsomirDataSeqFromRawData(
  rawdata,
  coldata,
  design = ~1L,
  pct = 0.1,
  n_snv = 1,
  whitelist = NULL,
  ...
)
}
\arguments{
\item{rawdata}{data.frame stored in metadata slot of \link{IsomirDataSeq} object.}

\item{coldata}{data frame containing groups for each sample}

\item{design}{a \code{formula} to pass to \link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet}}

\item{pct}{numeric used to remove isomiRs with an importance lower than
this value. Importance is calculated by dividing the isomiR count
by the total counts of the miRNA to which it maps.}

\item{n_snv}{numeric used to remove isomiRs with more than this number of
single nucleotide variants (indels are counted here).}

\item{whitelist}{character vector with sequences to keep even
if the filtering step would have removed them. They have to match
the \code{seq} column in the table.}

\item{...}{arguments provided to
\code{SummarizedExperiment}.
including rowData.}
}
\value{
\link{IsomirDataSeq} class object.
}
\description{
Process raw data like tables to speed up filtering steps.
}
\examples{
path <- system.file("extra", package="isomiRs")
fn_list <- list.files(path, pattern="mirna", full.names = TRUE)
de <- data.frame(row.names=c("f1" , "f2"),
                 condition = c("newborn", "newborn"))
ids <- IsomirDataSeqFromFiles(fn_list, coldata=de)

head(counts(ids))
IsomirDataSeqFromRawData(metadata(ids)[["rawData"]], de)
}
