% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipdDbClass.R
\docType{methods}
\name{getClosestComplete,IpdDb-method}
\alias{getClosestComplete,IpdDb-method}
\alias{getClosestComplete}
\title{Get closest full-length sequence}
\usage{
getClosestComplete(x, allele, locus = NULL)
}
\arguments{
\item{x}{The database connection; an \code{\link{IpdDb}} object.}

\item{allele}{A single allele as a string.}

\item{locus}{optional parameter used if the allele identifier is not found.}
}
\value{
A \code{\link[Biostrings:XStringSet-class]{Biostrings:DNAStringSet}}
object with the sequence 
of the closest full-length allele.
}
\description{
Get the sequence of the closest allele which for which a full-length 
  sequence is available.
}
\examples{
## Load the database 
hla <- loadHlaData()
## Get the loci
loci <- getLoci(hla)
## Get alleles of a locus
alleles <- getAlleles(hla, loci[1])
alleleOfInterest <- alleles[1]
## Get the closest complete sequence
seqs <- getClosestComplete(hla, alleleOfInterest, loci[1])

}
