% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCNV_BayesNet.R
\name{filterHighPNormals}
\alias{filterHighPNormals}
\title{filterHighPNormals: Filter the HMM identified CNV's by the CNV's posterior probability
of belonging to a normal state.}
\usage{
filterHighPNormals(MCMC_inferCNV_obj, HMM_states, BayesMaxPNormal, useRaster)
}
\arguments{
\item{MCMC_inferCNV_obj}{MCMC infernCNV object.}

\item{HMM_states}{InferCNV object with HMM states in expression data.}

\item{BayesMaxPNormal}{Option to filter CNV or cell lines by some probability threshold.}

\item{useRaster}{Option to use rasterization when plotting}
}
\value{
Returns a list of (MCMC_inferCNV_obj, HMM_states) With removed CNV's.
}
\description{
The following function will filter the HMM identified CNV's by the CNV's posterior
probability of belonging to a normal state identified by the function inferCNVBayesNet(). Will filter
CNV's based on a user desired threshold probability. Any CNV with a probability of being normal above
the threshold will be removed.
}
\examples{
data(mcmc_obj)

mcmc_obj_hmm_states_list <- infercnv::filterHighPNormals( MCMC_inferCNV_obj = mcmc_obj, 
                                          HMM_states        = HMM_states, 
                                          BayesMaxPNormal   = 0.5)

}
