% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_allele_frequency}
\alias{plot_allele_frequency}
\title{Plotting allele frequencies}
\usage{
plot_allele_frequency(allele_frequency)
}
\arguments{
\item{allele_frequency}{returned by \link{query_allele_frequencies}}
}
\value{
ggplot2 object displaying the allele frequencies on a world map.
}
\description{
\code{plot_allele_frequency} Generate a World map 
displaying the frequency of a given table of HLA alleles. Use the function
\link{query_allele_frequencies} to generate a table with allele frequencies.
}
\examples{

# select frequency of given allele
sel_allele_freq <- query_allele_frequencies(hla_selection = "A*02:01", 
hla_sample_size_pattern = "bigger_than", 
hla_sample_size = 10000, standard="g")

plot_allele_frequency(sel_allele_freq)

}
