% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{norm_entropy}
\alias{norm_entropy}
\title{Normalised Shannon Entropy}
\usage{
norm_entropy(cnt)
}
\arguments{
\item{cnt}{Numeric vector of non-negative counts (one entry per clone/
residue/OTU).  Zero counts are ignored.}
}
\value{
Numeric value in [0, 1]; `0` when all observations are in a
  single category.
}
\description{
Shannon entropy scaled to the interval [0, 1] by its maximum possible
value given *S* observed categories:
}
\details{
\deqn{H^* = \frac{H'}{\ln S}}

(also known as “Shannon evenness”).
}
\examples{
norm_entropy(c(40, 10, 10, 10))
}
