% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{dxx_dom}
\alias{dxx_dom}
\title{Dxx Dominance Index}
\usage{
dxx_dom(cnt, pct)
}
\arguments{
\item{cnt}{Numeric vector of non-negative counts.}

\item{pct}{A numeric value (0-100) for the target percentage.}
}
\value{
The smallest number of categories whose cumulative abundance is at
  least `pct` percent of the total abundance.
}
\description{
Calculates the minimum number of top clones/sequences (ranked by abundance)
that constitute a specified percentage of the total dataset. This function
allows the user to designate the percentage.
}
\examples{
counts <- c(100, 50, 20, 10, 5, rep(1, 5)) 
dxx_dom(counts, 80)
}
\seealso{
[d50_dom()]
}
