% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadGwasTrack}
\alias{loadGwasTrack}
\title{load a GWAS (genome-wide association study) track 
provided as a data.frame}
\usage{
loadGwasTrack(
  session,
  id,
  trackName,
  tbl.gwas,
  ymin = 0,
  ymax = 35,
  deleteTracksOfSameName = TRUE
)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{tbl.gwas}{data.frame, with at least "chrom" "start" "end" columns}

\item{ymin}{numeric defaults to 0}

\item{ymax}{numeric defaults to 35}

\item{deleteTracksOfSameName}{logical, default TRUE}
}
\value{
nothing
}
\description{
load a GWAS (genome-wide association study) track
provided as a data.frame
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
