% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadGFF3TrackFromLocalData}
\alias{loadGFF3TrackFromLocalData}
\title{load a GFF3 track defined by local data}
\usage{
loadGFF3TrackFromLocalData(
  session,
  id,
  trackName,
  tbl.gff3,
  color = "gray",
  colorTable,
  colorByAttribute,
  displayMode,
  trackHeight = 50,
  visibilityWindow,
  deleteTracksOfSameName = TRUE
)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{tbl.gff3}{data.frame  in standard 9-column GFF3 format}

\item{color}{character #RGB or a recognized color name.  ignored if 
colorTable and colorByAttribute provided}

\item{colorTable}{list, mapping a gff3 attribute, typically biotype, 
to a color}

\item{colorByAttribute}{character, name of a gff3 attribute in column 9, 
typically "biotype"}

\item{displayMode}{character,  "EXPANDED",  "SQUISHED" or "COLLAPSED"}

\item{trackHeight}{numeric defaults to 50}

\item{visibilityWindow}{numeric, Maximum window size in base pairs 
for which indexed annotations or variants are displayed}

\item{deleteTracksOfSameName}{logical, default TRUE}
}
\value{
nothing
}
\description{
load a local GFF3 track file
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo-GFF3.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
