% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadBedGraphTrackFromURL}
\alias{loadBedGraphTrackFromURL}
\title{load a bedgraph track from a URL}
\usage{
loadBedGraphTrackFromURL(
  session,
  id,
  trackName,
  url,
  color = "gray",
  trackHeight = 30,
  autoscale = TRUE,
  min = 0,
  max = 1,
  autoscaleGroup = -1,
  deleteTracksOfSameName = TRUE,
  quiet = TRUE
)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{url}{character}

\item{color}{character string, a legal CSS color, or "random", 
"gray" by default}

\item{trackHeight}{an integer, 30 (pixels) by default}

\item{autoscale}{logical}

\item{min}{numeric, consulted when autoscale is FALSE}

\item{max}{numeric, consulted when autoscale is FALSE}

\item{autoscaleGroup}{numeric(1) defaults to -1}

\item{deleteTracksOfSameName}{logical(1) defaults to TRUE}

\item{quiet}{logical, default TRUE, controls verbosity}
}
\value{
nothing
}
\description{
load a bedgraph track provided as a data.frame
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
