% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_tracks_dir}
\alias{get_tracks_dir}
\title{get_tracks_dir
Get the directory where tracks are stored. The directory can be defined 
with environmental variable.
If not defined the default is a directory called "tracks" in the temp 
directory.
We need a local directory to write files - for instance, 
a vcf file representing a genomic region of interest. 
We then tell shiny about that directory, so that shiny's built-in http server
can serve up files we write there, ultimately consumed by igv.js}
\usage{
get_tracks_dir(env_var = "TRACKS_DIR")
}
\arguments{
\item{env_var}{The name of the environmental variable to use.}
}
\value{
string with the path to the tracks directory.
}
\description{
get_tracks_dir
Get the directory where tracks are stored. The directory can be defined 
with environmental variable.
If not defined the default is a directory called "tracks" in the temp 
directory.
We need a local directory to write files - for instance, 
a vcf file representing a genomic region of interest. 
We then tell shiny about that directory, so that shiny's built-in http server
can serve up files we write there, ultimately consumed by igv.js
}
\examples{
gtd <- get_tracks_dir(env_var = "TRACKS_DIR")

}
\keyword{utils}
